﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RegForm.aspx.cs" Inherits="ccPublisherWeb.RegForm" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title></title>
   
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="RegisterLogin.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ErrorPanel.css" runat="server" />
</head>

<body>
   <script language="javascript" type="text/javascript" src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.JS.wz_tooltip.js"></script>
   
   <form id="form1" runat="server">

      <asp:PlaceHolder ID="Placeholder_Content" runat="server">
         <div id="RegForm">
            <div class="DCenter">
               <div id="UserForm">
                  <h2 id="Title_UserLogin" runat="server"><%# ccPublisherWeb.TextDic.TxGet("Text_RegistrationTitle") %></h2>
                  <h2 id="Title_EditProfile" runat="server"><%# ccPublisherWeb.TextDic.TxGet("Text_ProfilAendern") %></h2>

                  <asp:Table ID="RegTable" runat="server">
                     <%-- dynamically generated: Contains registration form build from DB --%>
                  </asp:Table>

                  <div id="SubmitButtons">
                     <input id="btFormSubmit" type="button" onclick="regForm.formSubmit()" runat="server" />
                  </div>
               </div>
            
               <div id="RegisterSuccess" style="display: none">
                  <asp:PlaceHolder ID="Placeholder_RegSuccess_Static" runat="server">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_RegistrationInfo") %>
                     <p>
                        <a id="PageBack" href="RegisterLogin.aspx">
                           <img src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.images.dummy.gif" border="0" />
                        </a>
                     </p>
                  </asp:PlaceHolder>
                  <asp:PlaceHolder ID="Placeholder_RegSuccess_Temporary" runat="server">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_TempRegistrationInfo") %>
                     <p>
                        <a id="PageBack" href="<%# ResolveUrl("~") %>" target="_top">
                           <img src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.images.dummy.gif" border="0" />
                        </a>
                     </p>
                  </asp:PlaceHolder>
               </div>

               <div id="Footer">
                  <%# ccPublisherWeb.TextDic.TxGet("Text_Copy_Rechte") %>
               </div>
            </div>
         </div>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Error" Visible="false" runat="server">
         <div id="ErrorDiv">
            <ccPublisherWeb:ErrorPanel ID="ErrorPanel" CssClass="ErrorPanel" runat="server" />
         </div>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_SessionExpired" Visible="false" runat="server">
         <div id="SessionExpired">
            <%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_Error_SessionExpired") %>
         </div>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Maintenance" Visible="false" runat="server">
         <div class="MaintenanceMode">
            <%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_DisabledMaintenance")%>
         </div>
      </asp:PlaceHolder>
      
      <asp:PlaceHolder ID="Placeholder_RegFormScript" runat="server">
         <script language="javascript" type="text/javascript" src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.JS.RegForm.js"></script>

         <script language="javascript" type="text/javascript">
            var regForm = new RegForm({
               regTableClientID        : "<%# RegTable.ClientID %>",
               regFormURL              : "<%# ResolveUrl("~/RegForm.aspx") %>",
               formType                : "<%# FormType %>",
               attrFormFieldTag        : "<%# ccPublisherWeb.FormDataControl.ATTR_FORM_FIELD_TAG %>",
               formInEdit              : <%# ccPublisherWeb.CommonFunc.JsBool(formInEdit) %>,
               modalProgressInstance   : <%# ModalProgressID %>,
               messageBoxInstance      : <%# MessageBoxID %>,
               mandFieldIDCustomerEmail: "<%# ccPublisherWeb.MandatoryFieldIDs.CustomerEMail %>",
               dummyPassword           : "<%# DUMMY_PASSWORD %>",
               autoRedirHomeTime       : <%# ccPublisherWeb.ApplicationVars.Current["RegistrationTemp_AutoRedirHome_Time"] %>,
               formResponseActions: {
                  Reload          : <%# (int)FormResponseActions.Reload %>,
                  ShowSuccessPanel: <%# (int)FormResponseActions.ShowSuccessPanel %>
               },
               validators: [
                  <asp:PlaceHolder ID="PlaceHolder_FormValidators" runat="server"></asp:PlaceHolder>
               ],
               formTypes: {
                  REG_FORM_NAME_TEMPORARY : "<%# ccPublisherWeb.CommonDefines.REG_FORM_NAME_TEMPORARY %>",
                  REG_FORM_NAME_STATIC    : "<%# ccPublisherWeb.CommonDefines.REG_FORM_NAME_STATIC %>"
               },
               strings: {
                  Text_EMailVorhanden               : "<%# ccPublisherWeb.TextDic.TxGet("Text_EMailVorhanden") %>",
                  Text_RegForm_ErrorEmailCheck_Title: "<%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_ErrorEmailCheck_Title") %>",
                  Text_RegForm_FormSubmit_Title     : "<%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_FormSubmit_Title") %>",
                  Text_Password_MinStrengthError    : "<%# ccPublisherWeb.TextDic.TxGet("Text_Password_MinStrengthError") %>"
               }
            });


            function passwordStrengthOK(pwdField) {
               return regForm.passwordStrengthOK(pwdField);
            }
         </script>
      </asp:PlaceHolder>
   </form>
   </body>
</html>
