﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="QnATableControl.ascx.cs" Inherits="ccPublisherWeb.QnATableControl" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register TagPrefix="asp" Namespace="System.Web.UI" Assembly="System.Web" %>

<asp:HiddenField ID="opencategories" runat="server" Value="" />
<asp:HiddenField ID="selectedtabpanel" runat="server" Value="0" />
<asp:HiddenField ID="triggeredbyscript" runat="server" Value="false" />

<script type="text/javascript" language="javascript">
    var showGraphicalSelection = '<%= ccQnA.GraphicalSelectionDisplayType() == ccQnA.GraphicalSelectionDisplayType() %>';
    var showGraphicalSelectionTabbed = '<%= ccQnA.GraphicalSelectionDisplayType() == ccQnA.eGraphicalSelectionDisplay.eSelectionDisplayTabbed %>';
    
    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      autoSizeGraphicalSelection                            --%>
    <%-- Description:   When configuration contains a graphical selection,    --%>
    <%--                auto-size all items of each group to have a more      --%>
    <%--                clean layout.                                         --%>
    <%-- -------------------------------------------------------------------- --%>
    function autoSizeGraphicalSelection(graphPanel) {
        if(showGraphicalSelectionTabbed == 'True')
        {
            $(".GraphicalSelectionTab").tabs({
                show : function(event, ui) {
                    autoSizeGraphSelPanel($(ui.panel));
                }
            });

            if("<%# (bool)ccPublisherWeb.ApplicationVars.Current["TabChangeAnimation"] %>" == "<%# bool.TrueString %>") {
                $("#GraphicalSelectionTab").tabs("option", "fx", { opacity: "toggle", duration: "fast" });
            }
               
            $(".GraphicalSelectionTab").css("display", "block"); 
        }

        if(typeof(graphPanel) == "undefined") {
            graphPanel = $(".GraphSelPanel");
        }

        autoSizeGraphSelPanel(graphPanel);
    }//autoSizeGraphicalSelection

    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      autoSizeGraphSelPanel                                 --%>
    <%-- Description:                                                         --%>
    <%-- -------------------------------------------------------------------- --%>
    function autoSizeGraphSelPanel(graphPanels) {
        graphPanels.each(function() {
            var iGraphPanel = $(this);

            if(iGraphPanel.is(":visible")) {
                var maxWidth = 0;

                iGraphPanel.find("A IMG").imagesLoaded(function() {
                iGraphPanel.find("A").each(function() {
                    // Get width of text and image. We have to use the largest value
                    var width = Math.max($(this).width(), $(this).find("IMG").outerWidth());
                    maxWidth = (width > maxWidth) ? width : maxWidth;
                });

                if(maxWidth > 0) {
                    iGraphPanel.find("A").css("width", maxWidth + "px");
                }
                });
            }
        });
    }//autoSizeGraphSelPanel

    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      reorderQna                                            --%>
    <%-- Description:   jquery sample for reordering qna lines.               --%>
    <%--                appropriate for georg fischer fittings only!          --%>
    <%-- -------------------------------------------------------------------- --%>
    function reorderQna()
    {
        var pipedimension = $('#QnaControl_QnaContainer #QnaControl_qna_accordion TABLE TR.qna_index_5');

        if(pipedimension)
        {
            pipedimension.insertBefore(pipedimension.prev());
        }
    }

    <%-- -------------------------------------------------------------------- --%>
    <%-- Function:      openConfigImageDialog                                 --%>
    <%-- Description:   opens the config image dialog.                        --%>
    <%-- -------------------------------------------------------------------- --%>
    function openConfigImageDialog(url, title, imgWidth, imgHeight) {
        var dlgWidth = Math.min(parseInt($(window).width() * 0.9), (imgWidth + 20));
        var dlgHeight = Math.min(parseInt($(window).height() * 0.9), (imgHeight + 30));
         
        prepareViewer(title, {
            width: dlgWidth,
            height: dlgHeight,
            left: -1,
            top: -1,
            scrolling: "auto",
            dragAndMaximize: false
        });
            
        if(viewerActive) {
            $(".Dialog_AppletViewer IFRAME").attr("src",
            "<%# ResolveUrl("~/ConfigImageViewer.aspx") %>?SRC=" + url);
        }
    }//openConfigImageDialog
</script>

<asp:PlaceHolder ID="qnahiddenfields" runat="server"></asp:PlaceHolder>
<asp:Panel ID="QnaContainer" runat="server"></asp:Panel>
<div id="QnaUserAttributes" style="display: none">
   <asp:PlaceHolder ID="Placeholder_UserAttributes" runat="server">
   </asp:PlaceHolder>
</div>