﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="ccPublisherWeb.ArtikelOld" Codebehind="ArtikelOld.aspx.cs" %>

<%@ Register Src="~/Controls/Pager.ascx" TagName="Pager" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/PageHeader.ascx" TagName="PageHeader" TagPrefix="ccPublisherWeb" %>
<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title>Artikel</title>

   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ArtikelGrid.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="Pager.css" runat="server" />

   <!--[if IE]>
      <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ArtikelGrid_IE.css" runat="server" />
   <![endif]-->

   <script language="javascript" type="text/javascript">
      function changeGridView(gridMode) {
         UnTip();

         $("#<%# hdGridMode.ClientID %>").val(gridMode);
         
         setTimeout(function() {
            <%# Page.ClientScript.GetPostBackEventReference(hdPostbackGridMode, "") %>;
         }, 0);
      }
      
      
      function changeGridSort(sortExpression, sortDirection, reset) {
         if(reset) {
            $("#<%# hdGridSortExpression.ClientID %>").val("");
            $("#<%# hdGridSortDirection.ClientID %>").val("");
         } else {
            $("#<%# hdGridSortExpression.ClientID %>").val(sortExpression);
            $("#<%# hdGridSortDirection.ClientID %>").val(sortDirection);
         }

         setTimeout(function() {
            <%# Page.ClientScript.GetPostBackEventReference(hdPostbackGridSort, "") %>;
         }, 0);
      }

      var artTTLoading = false;

      function artTT(artNum) {
         artTTLoading = true;
         Tip(
            '<%# ArtTTWaitHtml %>',
            DELAY, 200,
            FOLLOWMOUSE, false,
            LEFT, false
         );
      
         $.ajax({
            type: "GET",
            url: "ArticleTooltip.ashx?LA=<%# CommonSettings.SessionSettings.Language %>&PGID=<%# Request["wer"] %>&ART_NUM=" + artNum,
            cache: false,
            success: function(response) {
               if(artTTLoading) {
                  Tip(response,
                     DELAY, 0,
                     FOLLOWMOUSE, false,
                     LEFT, false
                  );
                  artTTLoading = false;
               }
            }
         });
      }
      
      
      function artTTClose() {
         artTTLoading = false;
         UnTip();
      }
      
      
      function redir(UrlOrForm) { 
         setTimeout(function() {location.href = UrlOrForm;}, 0);
      }
      
      function js_AddToBOM(FormName, ArtNr) {
         FormName.stvBOMArtNr1.value = ArtNr;
         FormName.submit();
         FormName.stvBOMArtNr1.value = "";
      }
      
   <asp:PlaceHolder ID="PlaceholderJavascript_ArticleSearch_Dropdown" runat="server">
      function ddlChangedUpdateGrid() {
         hideSMInfo();
      
         var ddlIDList = $("#<%# hdDropDownIDList.ClientID %>").val().split(";");
         var callbackValue = "";
         
         for(var i=0; i<ddlIDList.length; i++) {
            var ddlID   = ddlIDList[i];
            var smID    = $("#" + ddlID).attr("smid");
            var smValue = $("#" + ddlID).val();
            
            callbackValue += (i>0 ? "~" : "") + smID + "~" + smValue;
         }

         $("#<%# hdDDLSelectFilter.ClientID %>").val(callbackValue);

         <%# Page.ClientScript.GetPostBackEventReference(hdPostbackDDLSelect, "") %>;
      }
      
      var allowSMHide = false;
      
     
      function showSMInfo(boxClientID, ddlContentClientID, smID, ddlClientID) {
         allowSMHide = false;

         hideSMInfo();
         
         var ddl        = $("#" + ddlClientID);
         var ddlOptions = ddl.find("OPTION");
         var popupDDL   = $("#" + ddlContentClientID);
         var box        = $("#" + boxClientID);
         
         popupDDL.width(box.width() - 2);
         popupDDL.html("");
         
         if(ddl.disabled) {
            return;
         }
      
         var actValList = '';
         ddlOptions.each(function(index) {
            var ddlValue = $(this).attr("value");
            
            actValList += (index > 0 ? ";" : "") + ddlValue;
         });

         actValList = ccPublisherWeb.URLEncode(actValList);
      
         var containerScrollTop = $("#ArtikelListe").scrollTop();
         var lookupURL = 'ArticleDDLSmInfo.ashx?SMID=' + smID + '&PGID=<%# PGID %>&laid=<%# CommonSettings.SessionSettings.Language %>&DDLID=' + ddlClientID + '&ACTVALS=' + actValList;

         $(".PSachmerkmal[smid='" + smID + "'] A.Title").toggleClass("Selected", true);

         $.ajax({
            type: "GET",
            url: lookupURL,
            cache: false,
            success: function(response) {
               ddl.css("visibility", "hidden");
               popupDDL.html(response);
               popupDDL.css('display', 'block');

               setTimeout(function() { allowSMHide = true; }, 300);
            }
         });
      }
      
      
      document.onclick = function() {
         if(allowSMHide) {
            hideSMInfo();

            allowSMHide = false;
         }
      };
      
      
      function hideSMInfo() {
         $(".PSachmerkmal A.Title").removeClass("Selected");
         $("DIV[popupddl='1']").css("display", "none");
         $("SELECT[smid]").css("visibility", "visible");
      }
      
      
      function selectFromSMInfo(smID, ddlClientID, smValue, smInfo) {
         hideSMInfo();
         
         var ddl           = $("#" + ddlClientID);
         var currentSelVal = ddl.val();

         if(smValue != "") {
            $(".PSachmerkmal[smid='" + smID + "'] DIV.SelValue").html(
               String.format(
                  "<span class=\"Value\">{0}</span>" +
                  "<span class=\"Description\">{1}</span>",
                  smValue,
                  smInfo
               )
            );
         } else {
            $(".PSachmerkmal[smid='" + smID + "'] DIV.SelValue").html("<span class=\"Value\">&nbsp;</span>");
         }

         if(currentSelVal != smValue) {
            ddl.val(smValue);
            ddlChangedUpdateGrid();
         }
      }
   </asp:PlaceHolder>
      
   <asp:PlaceHolder ID="PlaceholderJavascript_ArticleSearch_Text" runat="server">
      function searchArtID(e) {
         var searchString = $.trim($("#txArtIDSearch").val());
         
         if((searchString.length >= <%# ApplicationVars.Current["MinSearchLength"] ?? "3" %>) && (searchString != '<%# ccPublisherWeb.TextDic.JavascriptEncode(ccPublisherWeb.TextDic.TxGet("Text_SuchFeldInhalt")) %>')) {
            $("#<%# hdArticleIDSearch.ClientID %>").val(searchString);
            <%# Page.ClientScript.GetPostBackEventReference(hdPostbackArticleIDSearch, "") %>;
         } else {
            alert('<%# string.Format(ccPublisherWeb.TextDic.TxGet("Text_SuchFeld"), ApplicationVars.Current["MinSearchLength"] ?? "3") %>');
         }
         
         if(e != null) {
            return (e.keyCode != 13);
         } else {
            return true;
         }
      }
   </asp:PlaceHolder>
   </script>
</head>
<body class="ArtListBody">
   <ccPublisherWeb:JavascriptRessource ScriptName="wz_tooltip.js" UseHandler="false" runat="server" />

   <form id="form1" runat="server">
      <asp:ScriptManager ID="ScriptManager1" runat="server" />
      
      <script language="javascript" type="text/javascript">
         Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(BeginRequestHandler);
         Sys.WebForms.PageRequestManager.getInstance().add_endRequest(EndRequestHandler);
         
         var modalTimer;
         
         function BeginRequestHandler(sender, args) {
           modalTimer = setTimeout(function() {
               <%# ModalProgressID %>.Show();
           }, 500);
         }
         
         function EndRequestHandler(sender, args) {
            if(modalTimer) {
              clearTimeout(modalTimer);
            }

            <%# ModalProgressID %>.Hide();
         }
      </script>
      <ccPublisherWeb:PageHeader ID="PageHeader1" CssClass="PageHeader" runat="server" />

      <div id="ArtikelListe">
         <div id="ArtikelListe_Inner">
            <asp:PlaceHolder ID="Placeholder_ArticleSearch_Dropdown" runat="server">
               <fieldset id="ArticleSearch_Dropdown">
                  <legend><%# ccPublisherWeb.TextDic.TxGet("Text_ArticleList_SearchMode_DDL") %></legend>
                  
                  <table id="ArticleSearch_DropdownContainer" border="0" cellpadding="0" cellspacing="0">
                     <tr>
                        <td class="ColumnLeft">
                           <asp:PlaceHolder ID="ArticleSearch_DropdownColumn1" runat="server"></asp:PlaceHolder>
                        </td>

                        <td class="ColumnRight">
                           <asp:PlaceHolder ID="ArticleSearch_DropdownColumn2" runat="server"></asp:PlaceHolder>
                        </td>
                     </tr>
                  </table>
                  
                  <asp:HiddenField ID="hdDropDownIDList" runat="server" />
               </fieldset>
               <div id="ArticleSearch_Dropdown_Spacer"></div>
            </asp:PlaceHolder>
            
            <asp:PlaceHolder ID="Placeholder_ArticleSearch_Text" runat="server">
               <div id="ArticleSearch_Text">
                  <div id="ArticleSearchBox">
                     <div class="Header">
                        <span><%# ccPublisherWeb.TextDic.TxGet("Text_Suche") %></span>
                     </div>
                     <div class="Content">
                        <span id="SearchTitle"><%# ccPublisherWeb.TextDic.TxGet("Text_Such_nach") %></span>
                        <input id="txArtIDSearch" class="TextBlur" value="<%# ccPublisherWeb.TextDic.TxGet("Text_SuchFeldInhalt") %>" onfocus="this.value='';this.className=''" onkeydown="if(event.keyCode == 13) { return searchArtID(event); }" type="text" />
                        <a id="SearchButton_Link" href="#" onclick="searchArtID()" title="<%# ccPublisherWeb.TextDic.TxGet("Text_Suchen") %>">
                           <%# ccPublisherWeb.TextDic.TxGet("Text_Suchen") %>
                        </a>
                        <input id="SearchButton_Button" type="button" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Suchen") %>" onclick="searchArtID()" />
                     </div>
                  </div>
               </div>
            </asp:PlaceHolder>
         
            <asp:UpdatePanel ID="UpdatePanel_Grid" runat="server">
               <ContentTemplate>
                  <asp:PlaceHolder ID="Placeholder_GridSection" runat="server">
                     <div class="Header">
                        <div class="HeaderLeft">
                           <span><%# ccPublisherWeb.TextDic.TxGet("Text_Gefundene_Artikel") %></span>&nbsp;<asp:Label ID="lbAnzArtikelGefunden" CssClass="NumFound" runat="server" />
                        </div>
                        
                        <div class="HeaderRight">
                           <asp:PlaceHolder ID="Placeholder_ViewSwitch" runat="server">
                              <table border="0" cellpadding="0" cellspacing="0">
                                 <tr>
                                    <td><%# ccPublisherWeb.TextDic.TxGet("Text_Ansicht_Waehlen") %></td>
                                    <td><div class="ButtonSpacing"></div></td>
                                    <td>
                                       <asp:Panel ID="ButtonAnsichtTextOnly" runat="server" />
                                    </td>
                                    <td><div class="ButtonSpacing"></div></td>
                                    <td>
                                       <asp:Panel ID="ButtonAnsichtImagesAndText" runat="server" />
                                    </td>
                                    <td><div class="ButtonSpacing"></div></td>
                                    <td>
                                       <asp:Panel ID="ButtonAnsichtImages" runat="server" />
                                    </td>
                                 </tr>
                              </table>
                           </asp:PlaceHolder>
                        </div>
                     </div>

                     <center>
                        <div id="GridContent" class="GridContent" runat="server">
                           <asp:GridView
                              ID="GridArtikel"
                              AutoGenerateColumns="false"
                              AllowPaging="true"
                              GridLines="None"
                              PagerSettings-Visible="false"
                              OnPageIndexChanging="GridArtikel_PageIndexChanging"
                              CssClass="GridArtikel"
                              HeaderStyle-CssClass="GridArtikel_Header"
                              EnableViewState="false"
                              runat="server"
                           >
                              <Columns>
                                 <asp:TemplateField ItemStyle-CssClass="Item_Thumbnail">
                                    <ItemTemplate>
                                       <div
                                          class="ThumbnailCadDaten"
                                          onclick="<%# evalArtikelLink(Eval("ArtikelNr").ToString()) %>"
                                          title="<%# ccPublisherWeb.TextDic.TxGet("Text_alt_Vorschau") %>"
                                          onmouseover="Tip('<div style=\'background-image:url(<%# Eval("ImgLarge") %>);background-positon:center center;background-repeat:no-repeat;width:<%# ccPublisherWeb.ApplicationVars.Current["LargeArtikelPrevWidth"] %>px;height:<%# ccPublisherWeb.ApplicationVars.Current["LargeArtikelPrevHeight"] %>px\' class=\'ThumbnailCadDatenTooltip\'></div>')"                           
                                          onmouseout="UnTip()"
                                          style="background-repeat: no-repeat; width:<%# ccPublisherWeb.ApplicationVars.Current["SmallArtikelPrevWidth"] %>px;height:<%# ccPublisherWeb.ApplicationVars.Current["SmallArtikelPrevHeight"] %>px"
                                       >
                                          <div style="background-image:url(<%# Eval("ImgSmall") %>);width:<%# ccPublisherWeb.ApplicationVars.Current["SmallArtikelPrevWidth"] %>px;height:<%# ccPublisherWeb.ApplicationVars.Current["SmallArtikelPrevHeight"] %>px" />
                                       </div>
                                    </ItemTemplate>
                                 </asp:TemplateField>
                                 
                                 <asp:TemplateField HeaderStyle-Wrap="false" ItemStyle-CssClass="Item_ArtNum">
                                    <HeaderTemplate>
                                       <div class="HeaderCol">
                                          <span><%# ccPublisherWeb.TextDic.TxGet("Text_ArtikelNr") %></span>
                                          
                                          <a
                                             class="<%# (GridViewSortExpression == "ArtikelNr" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Descending) ? "SortDesc_Sel" : "SortDesc" %>"
                                             href="javascript:changeGridSort('ArtikelNr', <%# (int)System.Web.UI.WebControls.SortDirection.Descending %>, <%# (GridViewSortExpression == "ArtikelNr" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Descending) ? "true" : "false" %>)"
                                             title="<%# ccPublisherWeb.TextDic.TxGet("Text_Absteigend") %>"
                                          >
                                             <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" border="0" />
                                          </a>
                                          
                                          <a
                                             class="<%# (GridViewSortExpression == "ArtikelNr" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Ascending) ? "SortAsc_Sel" : "SortAsc" %>"
                                             href="javascript:changeGridSort('ArtikelNr', <%# (int)System.Web.UI.WebControls.SortDirection.Ascending %>, <%# (GridViewSortExpression == "ArtikelNr" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Ascending) ? "true" : "false" %>)"
                                             title="<%# ccPublisherWeb.TextDic.TxGet("Text_Aufsteigend") %>"
                                          >
                                             <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" border="0" />
                                          </a>
                                       </div>
                                    </HeaderTemplate>
                                    
                                    <ItemTemplate>
                                       <span style="white-space:nowrap"><%# ArtikelHelper.HighlightSearchString(Eval("ArtikelNr").ToString(), CommonSettings.SessionSettings.SearchIndex)%></span>
                                    </ItemTemplate>
                                 </asp:TemplateField>
                                 
                                 <asp:TemplateField ItemStyle-Width="100%" HeaderStyle-Wrap="false" ItemStyle-CssClass="Item_ArtBezeichnung">
                                    <HeaderTemplate>
                                       <div class="HeaderCol">
                                          <span><%# ccPublisherWeb.TextDic.TxGet("Text_Bezeichnung") %></span>
                                          
                                          <a
                                             class="<%# (GridViewSortExpression == "ArtikelBezeichnung" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Descending) ? "SortDesc_Sel" : "SortDesc" %>"
                                             href="javascript:changeGridSort('ArtikelBezeichnung', <%# (int)System.Web.UI.WebControls.SortDirection.Descending %>, <%# (GridViewSortExpression == "ArtikelBezeichnung" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Descending) ? "true" : "false" %>)"
                                             title="<%# ccPublisherWeb.TextDic.TxGet("Text_Absteigend") %>"
                                          >
                                             <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" border="0" />
                                          </a>
                                             
                                          <a
                                             class="<%# (GridViewSortExpression == "ArtikelBezeichnung" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Ascending) ? "SortAsc_Sel" : "SortAsc" %>"
                                             href="javascript:changeGridSort('ArtikelBezeichnung', <%# (int)System.Web.UI.WebControls.SortDirection.Ascending %>, <%# (GridViewSortExpression == "ArtikelBezeichnung" && GridViewSortDirection == System.Web.UI.WebControls.SortDirection.Ascending) ? "true" : "false" %>)"
                                             title="<%# ccPublisherWeb.TextDic.TxGet("Text_Aufsteigend") %>"
                                          >
                                             <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" border="0" />
                                          </a>
                                       </div>
                                    </HeaderTemplate>
                                    
                                    <ItemTemplate>
                                       <span style="white-space:nowrap"><%# ArtikelHelper.HighlightSearchString(Eval("ArtikelBezeichnung").ToString(), CommonSettings.SessionSettings.SearchIndex)%></span>
                                    </ItemTemplate>
                                 </asp:TemplateField>                               
                                 
                                 <asp:TemplateField HeaderStyle-Wrap="false" HeaderStyle-CssClass="Header_Data"  ItemStyle-CssClass="Item_LinkCadDaten">
                                    <ItemTemplate>
                                       <div style="text-align:center">
                                          <a class="LinkCadDaten" href="javascript:;" onclick="<%# evalArtikelLink(Eval("ArtikelNr").ToString()) %>">
                                             <img alt="LinkCadDaten" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" border="0" />
                                             <span><%# ccPublisherWeb.TextDic.TxGet("Text_CAD") %></span>
                                          </a>
                                       </div>
                                    </ItemTemplate>
                                 </asp:TemplateField>  

                                 <asp:TemplateField HeaderStyle-Wrap="false">
                                    <ItemTemplate>
                                       <div style="text-align:center">
                                          <a class="LinkDocDaten" target="_blank" href="<%# ArtikelHelper.CreateDocLink(Eval("ArtikelNr").ToString()) %>">
                                             <img alt="LinkDocDaten" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Artikel), "ccPublisherWeb.images.dummy.gif") %>" 
                                             title = "<%# ArtikelHelper.GetDocName(Eval("ArtikelNr").ToString()) %>"
                                             border="0" />
                                             <span>PDF</span>
                                          </a>
                                       </div>
                                    </ItemTemplate>
                                 </asp:TemplateField> 
                              </Columns>
                           </asp:GridView>
                        </div>
                     </center>
                     
                     <div id="PagerDiv" runat="server">
                        <ccPublisherWeb:Pager
                           ID="GridArtikelPager"
                           GridControlID="GridArtikel"
                           OnPagerChange="GridArtikel_PagerChange"
                           CssClass="Pager"
                           runat="server" />
                     </div>
                  </asp:PlaceHolder>
                  
                  <div style="display: none">
                     <asp:HiddenField ID="hdGridMode" runat="server" />
                     <asp:HiddenField ID="hdGridSortExpression" runat="server" />
                     <asp:HiddenField ID="hdGridSortDirection" runat="server" />
                     
                     <asp:Button ID="hdPostbackGridMode" OnClick="GridModeChanged_Click" runat="server" />
                     <asp:Button ID="hdPostbackGridSort" OnClick="GridSortChanged_Click" runat="server" />
                     <asp:Button ID="hdPostbackDDLSelect" OnClick="PostbackDDLSelect" runat="server" />
                     <asp:Button ID="hdPostbackArticleIDSearch" OnClick="PostbackArticleIDSearch" runat="server" />
                     
                     <asp:HiddenField ID="hdArticelSelectionMode" runat="server" />
                     <asp:HiddenField ID="hdGridViewSortExpression" runat="server" />
                     <asp:HiddenField ID="hdGridViewSortDirection" runat="server" />
                     
                     <asp:HiddenField ID="hdDDLSelectFilter" runat="server" />
                     <asp:HiddenField ID="hdArticleIDSearch" runat="server" />
                  </div>
               </ContentTemplate>
            </asp:UpdatePanel>
         </div>
      </div>

      <script language="javascript" type="text/javascript">
         $(function() {
            <%-- Hide CAD Viewer in side panel --%>
            try {
               if(parent && parent.Leer) {
                  parent.Leer.PrevWinHidden();
               }
            } catch(e) { }

            <%# ccPublisherWeb.CustomApplicationHooks.Factory.ArticleList_PageLoadClientScript %>
         });
      </script>
   </form>
</body>
</html>
